IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='Valores_Tarjetas_Marcas' AND xtype='U')
BEGIN
	CREATE TABLE Valores_Tarjetas_Marcas 
	(
		Id_Tar_Marca				VARCHAR(15) NOT NULL,
		Descripcion					VARCHAR(100),
		Descrip_Corta				VARCHAR(50)
	)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Valores_Tarjetas_Marcas' AND xtype='U')
BEGIN
	ALTER TABLE Valores_Tarjetas_Marcas ADD CONSTRAINT PK_VTMA_PorId PRIMARY KEY CLUSTERED (Id_Tar_Marca)	
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Valores_Tarjetas_Marcas' AND xtype='U')
BEGIN
	CREATE INDEX IX_VTMA_PorDescrip ON Valores_Tarjetas_Marcas (Descripcion)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Valores_Tarjetas_Marcas' AND xtype='U')
BEGIN
	-------------------------------------------------------------------------------------

	--TARJETAS DE CREDITO

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_C_AMEX', 'TARJETA CREDITO AMERICAN EXPRESS (AR)', 'AMEX CREDITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_C_CABAL', 'TARJETA CREDITO CABAL (AR)', 'CABAL CREDITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_C_NARANJA', 'TARJETA CREDITO NARANJA (AR)', 'NARANJA CREDITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_C_NEVADA', 'TARJETA CREDITO NEVADA (AR)', 'NEVADA CREDITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_C_SHOPPING', 'TARJETA CREDITO SHOPPING (AR)', 'SHOPPING CREDITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_C_MASTER', 'TARJETA CREDITO MASTERCARD (AR)', 'MASTERCARD CREDITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_C_MASTPRISMA', 'TARJETA CREDITO MASTERCARD PRISMA (AR)', 'MASTERCARD PRISMA CREDITO')
	
	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('UY_C_MASTER', 'TARJETA CREDITO MASTERCARD (UY)', 'MASTERCARD CREDITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_C_VISALIQQ', 'TARJETA CREDITO VISA DEBLIQC (AR)', 'VISA CREDITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_C_VISAMOV', 'TARJETA CREDITO VISA VISAMOV (AR)', 'VISA CREDITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('UY_C_VISANET', 'TARJETA CREDITO VISANET (UY)', 'VISA CREDITO')

	-------------------------------------------------------------------------------------

	--TARJETAS DE DEBITO

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_D_CABAL', 'TARJETA DEBITO CABAL (AR)', 'CABAL DEBITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_D_DINERS', 'TARJETA DEBITO DINERS CLUB (AR)', 'DINERS CLUB DEBITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_D_VISALIQ', 'TARJETA DEBITO VISA DEBLIQD (AR)', 'VISA DEBITO')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('UY_D_OCA', 'BANCO OCA DEBITO (UY)', 'TARJETA BANCO OCA')

	-------------------------------------------------------------------------------------

	--BANCOS

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_B_GALICIACBU', 'BANCO GALICIA CBU (AR)', 'BANCO GALICIA CBU')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_B_GALICIAINT', 'BANCO GALICIA COBRANZA INTEGRAL (AR)', 'BANCO GALICIA COBRANZA INTEGRAL')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_B_CREDICOCBU', 'BANCO CREDICOOP CBU (AR)', 'BANCO CREDICOOP CBU')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_B_SUPERVICBU', 'BANCO SUPERVILLE CBU (AR)', 'BANCO SUPERVILLE CBU')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_B_SANTANDCBU', 'BANCO SANTANDER CBU (AR)', 'BANCO SANTANDER CBU')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_B_MUNROSCBU', 'BANCO MUNICIPAL DE ROSARIO CBU (AR)', 'BANCO MUNICIPAL DE ROSARIO CBU')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_B_MACROCBU', 'BANCO MACRO CBU (AR)', 'BANCO MACRO CBU')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_B_HSBCCBU', 'BANCO HSBC CBU (AR)', 'BANCO HSBC CBU')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_B_PATAGOCBU', 'BANCO PATAGONIA CBU (AR)', 'BANCO PATAGONIA CBU')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_B_ICBCCBU', 'BANCO ICBC CBU (AR)', 'BANCO ICBC CBU')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('UY_B_SCOTIACBU', 'BANCO SCOTIABANK CBU (UY)', 'BANCO SCOTIABANK CBU')	

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('UY_B_ITAUCBU', 'BANCO ITAU CBU (UY)', 'BANCO ITAU CBU')	

	-------------------------------------------------------------------------------------
	
	--MEDIOS DE PAGO

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_M_ROELA', 'BANCO ROELA MEDIO PAGO (AR)', 'BANCO ROELA')
	
	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_M_PMC', 'PAGO MIS CUENTAS BANELCO (AR)', 'PAGO MIS CUENTAS')
	
	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_M_PAGOFACIL', 'PAGO FACIL (AR)', 'PAGO FACIL')
	
	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_M_RAPIPAGO', 'RAPIPAGO (AR)', 'RAPIPAGO')
	
	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_M_MICLUB', 'MICLUB.INFO (AR)', 'MICLUB.INFO')
	
	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_M_PAGOTICARC', 'PAGO TIC POR ARCHIVO (AR)', 'PAGO TIC')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_M_PAGOTICAPI', 'PAGO TIC POR API (AR)', 'PAGO TIC')

	-------------------------------------------------------------------------------------

	--PRESTADORES

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_P_CLEVERBANK', 'CLEVERSOFT BANKING (AR)', 'CLEVERSOFT BANKING')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_P_IAFPRPM', 'I.A.F.P.R.P.M. (AR)', 'I.A.F.P.R.P.M.')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_P_CIRMILITAR', 'CIRCULO MILITAR (AR)', 'CIRCULO MILITAR')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_P_SMSV', 'S.M.S.V. (AR)', 'S.M.S.V.')

	INSERT INTO Valores_Tarjetas_Marcas
	(Id_Tar_Marca, Descripcion, Descrip_Corta)
	VALUES
	('AR_P_CTGN', 'C.T.G.N. (AR)', 'C.T.G.N.')
END
GO
